/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.contact;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.ws.contact.VWContactAddressPanel;
import filenet.vw.toolkit.utils.ws.contact.VWContactDescriptionPanel;
import filenet.vw.toolkit.utils.ws.contact.VWContactEmailPanel;
import filenet.vw.toolkit.utils.ws.contact.VWContactPhonePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.juddi.datatype.PersonName;
import org.apache.juddi.datatype.business.Contact;

public class VWUDDIBusinessContactDialog
extends VWModalDialog
implements ActionListener,
DocumentListener,
KeyListener,
ChangeListener,
IVWToolbarBorderActionListener {
    public static final int STATUS_APPLY = 0;
    public static final int STATUS_CANCEL = 1;
    private Frame m_parentFrame = null;
    private JTabbedPane m_tabbedPanel = new JTabbedPane();
    private JButton m_ApplyButton = new JButton(VWResource.s_apply);
    private JButton m_cancelButton = new JButton(VWResource.s_cancel);
    private JButton m_helpButton = new JButton(VWResource.s_help);
    private VWToolbarBorder m_toolBarBorder = null;
    private JTextField m_contactNameTextField = null;
    private JTextField m_typeTextField = null;
    private Vector m_contactVector = null;
    private Contact m_contact = null;
    private boolean m_bChanged = false;
    private int m_nRetStatus = 0;
    private int m_index;
    private Component m_currentSelectedTab = null;
    private PersonName m_personName = null;
    private Vector m_addressVector = null;
    private Vector m_emailVector = null;
    private String m_useType = null;
    private VWContactDescriptionPanel m_descPanel = null;
    private VWContactAddressPanel m_addressPanel = null;
    private VWContactPhonePanel m_phonePanel = null;
    private VWContactEmailPanel m_emailPanel = null;

    public VWUDDIBusinessContactDialog(Frame parent, Vector theContacts, int index) {
        super(parent);
        try {
            this.m_parentFrame = parent;
            this.m_contactVector = theContacts;
            this.m_index = index;
            this.m_contact = (Contact)this.m_contactVector.elementAt(index);
            if (this.m_contact != null) {
                this.m_personName = this.m_contact.getPersonName();
                this.m_useType = this.m_contact.getUseType();
                if (this.m_useType == null) {
                    this.m_useType = "";
                }
                this.m_addressVector = this.m_contact.getAddressVector();
                this.m_emailVector = this.m_contact.getEmailVector();
            }
            this.setTitle(VWResource.s_businessContact);
            this.getContentPane().setLayout(new BorderLayout());
            Dimension dim = VWStringUtils.stringToDimension("555,335");
            if (dim == null) {
                dim = new Dimension(500, 300);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            Font aFont = this.getFont();
            Font boldFont = new Font(aFont.getName(), 1, aFont.getSize());
            this.m_tabbedPanel.setFont(boldFont);
            this.m_descPanel = new VWContactDescriptionPanel(this.m_parentFrame, this.m_contact);
            this.m_tabbedPanel.add(VWResource.s_description, this.m_descPanel);
            this.m_addressPanel = new VWContactAddressPanel(this.m_parentFrame, this.m_contact);
            this.m_tabbedPanel.add(VWResource.s_address, this.m_addressPanel);
            this.m_phonePanel = new VWContactPhonePanel(this.m_parentFrame, this.m_contact);
            this.m_tabbedPanel.add(VWResource.s_phone, this.m_phonePanel);
            this.m_emailPanel = new VWContactEmailPanel(this.m_parentFrame, this.m_contact);
            this.m_tabbedPanel.add(VWResource.s_email, this.m_emailPanel);
            this.m_tabbedPanel.setSelectedIndex(0);
            this.m_tabbedPanel.addChangeListener(this);
            this.createTopPanel();
            this.getContentPane().add((Component)this.m_toolBarBorder, "First");
            this.getContentPane().add((Component)this.m_tabbedPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.m_ApplyButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.setApplyButtonState();
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getStatus() {
        return this.m_nRetStatus;
    }

    public boolean hasChanged() {
        return this.m_bChanged || this.m_descPanel.hasChanged() || this.m_addressPanel.hasChanged() || this.m_phonePanel.hasChanged() || this.m_emailPanel.hasChanged();
    }

    private boolean validateData() {
        String name;
        boolean bSuccess = true;
        this.stopEditing();
        if (this.m_bChanged && ((name = this.m_contactNameTextField.getText()) == null || name.length() < 1)) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_missingContactName, VWResource.s_errorMessage, 1);
            bSuccess = false;
        }
        if (bSuccess && this.m_descPanel.hasChanged()) {
            bSuccess = this.m_descPanel.validateData();
        }
        if (bSuccess && this.m_addressPanel.hasChanged()) {
            bSuccess = this.m_addressPanel.validateData();
        }
        if (bSuccess && this.m_phonePanel.hasChanged()) {
            bSuccess = this.m_phonePanel.validateData();
        }
        if (bSuccess && this.m_emailPanel.hasChanged()) {
            bSuccess = this.m_emailPanel.validateData();
        }
        return bSuccess;
    }

    public void insertUpdate(DocumentEvent event) {
        this.setApplyButtonState();
        this.m_bChanged = true;
    }

    public void removeUpdate(DocumentEvent event) {
        this.setApplyButtonState();
        this.m_bChanged = true;
    }

    public void changedUpdate(DocumentEvent event) {
        this.m_bChanged = true;
    }

    private void setApplyButtonState() {
        String tempString;
        if (this.m_ApplyButton == null) {
            return;
        }
        boolean bEnable = false;
        if (this.m_contactNameTextField != null && (tempString = this.m_contactNameTextField.getText()) != null) {
            tempString.trim();
            if (tempString.length() > 0) {
                bEnable = true;
            }
        }
        if (this.m_ApplyButton.isEnabled() != bEnable) {
            this.m_ApplyButton.setEnabled(bEnable);
        }
    }

    private boolean update() {
        boolean bSuccess = this.validateData();
        if (bSuccess) {
            boolean bUpdateContact = false;
            if (this.m_bChanged) {
                PersonName pn = this.m_contact.getPersonName();
                if (pn == null) {
                    pn = new PersonName(this.m_contactNameTextField.getText());
                    this.m_contact.setPersonName(pn);
                } else {
                    pn.setValue(this.m_contactNameTextField.getText());
                }
                this.m_contact.setPersonName(pn);
                this.m_contact.setUseType(this.m_typeTextField.getText());
                bUpdateContact = true;
            }
            if (this.m_descPanel.hasChanged()) {
                Vector descVector = this.m_descPanel.getDescriptionVector();
                this.m_contact.setDescriptionVector(descVector);
                bUpdateContact = true;
            }
            if (this.m_addressPanel.hasChanged()) {
                Vector addressVector = this.m_addressPanel.getAddressVector();
                this.m_contact.setAddressVector(addressVector);
                bUpdateContact = true;
            }
            if (this.m_phonePanel.hasChanged()) {
                Vector phoneVector = this.m_phonePanel.getPhoneVector();
                this.m_contact.setPhoneVector(phoneVector);
                bUpdateContact = true;
            }
            if (this.m_emailPanel.hasChanged()) {
                Vector emailVector = this.m_emailPanel.getEmailVector();
                this.m_contact.setEmailVector(emailVector);
                bUpdateContact = true;
            }
            if (bUpdateContact) {
                this.m_contactVector.setElementAt(this.m_contact, this.m_index);
            }
        }
        return bSuccess;
    }

    public void releaseResources() {
        this.m_contactNameTextField = null;
        this.m_typeTextField = null;
        if (this.m_descPanel != null) {
            this.m_descPanel.releaseResources();
            this.m_descPanel = null;
        }
        if (this.m_addressPanel != null) {
            this.m_addressPanel.releaseResources();
            this.m_addressPanel = null;
        }
        if (this.m_phonePanel != null) {
            this.m_phonePanel.releaseResources();
            this.m_phonePanel = null;
        }
        if (this.m_emailPanel != null) {
            this.m_emailPanel.releaseResources();
            this.m_emailPanel = null;
        }
        if (this.m_tabbedPanel != null) {
            this.m_tabbedPanel.removeAll();
            this.m_tabbedPanel = null;
        }
        if (this.m_ApplyButton != null) {
            this.m_ApplyButton.removeActionListener(this);
            this.m_ApplyButton.removeAll();
            this.m_ApplyButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopEditing();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_nRetStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_ApplyButton) {
            try {
                if (this.update()) {
                    this.m_nRetStatus = 0;
                    this.setVisible(false);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc090.htm");
        }
    }

    public void stateChanged(ChangeEvent event) {
    }

    public Vector getContactVector() {
        return this.m_contactVector;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.m_bChanged = true;
    }

    private JPanel createTopPanel() {
        JPanel panel = null;
        try {
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.s_businessContact, 0);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            GridBagConstraints gbConst = new GridBagConstraints();
            panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new GridBagLayout());
            gbConst.gridwidth = 1;
            gbConst.anchor = 21;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.fill = 0;
            panel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_name)), gbConst);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_contactNameTextField = this.m_personName != null ? new JTextField(this.m_personName.getValue()) : new JTextField();
            this.m_contactNameTextField.addKeyListener(this);
            this.m_contactNameTextField.getDocument().addDocumentListener(this);
            panel.add((Component)this.m_contactNameTextField, gbConst);
            ++gbConst.gridx;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            panel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_type)), gbConst);
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            this.m_typeTextField = new JTextField(this.m_useType);
            this.m_typeTextField.addKeyListener(this);
            panel.add((Component)this.m_typeTextField, gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_ApplyButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private void stopEditing() {
        this.m_descPanel.stopEditing();
        this.m_addressPanel.stopEditing();
        this.m_phonePanel.stopEditing();
        this.m_emailPanel.stopEditing();
    }
}

